package bk;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BkController extends HttpServlet{
	private static final long serialVersionUID = 7373173989151160723L;
	private HashMap<String, Object> mActionMap;						//command Ͽ  ׼ Ŭ .

	/**
	 *  ۽ 1 ҷ.  ʱȭ ۾ Ѵ.
	 */
	@Override
	public void init(ServletConfig config) throws ServletException {
		String props = config.getInitParameter("bkConfig");				//web.xml ǵ Ƽ θ ޾ƿ
		Properties pr = new Properties();										//Ƽ ü 
		
		FileInputStream f = null;												//Ƽ   Ʈ ü 
		try {
			f = new FileInputStream(props);									//Ƽ  
			pr.load(f);																//  Ƽ ü 
		}
		catch(Exception e){ e.printStackTrace(); }
		finally {
			try {
				if(f!=null) f.close();
			}
			catch(Exception e){ e.printStackTrace(); }
		}
		
		Iterator<Object> keys = pr.keySet().iterator();						//Ƽ Ű ޾ƿ
		
		mActionMap = new HashMap<String, Object>();
		//Ű شϴ ׼ Ŭ ޾Ƽ ü Ͽ  
		while(keys.hasNext()) {
			String cmd = keys.next().toString();				//Ű ޾ƿ. urlĿǵ
			String className = pr.getProperty(cmd);		//Ű شϴ ׼ Ŭ ̸ ޾ƿ
			try {
				Class<?> cmdClass = Class.forName(className);	//Ŭ ͼ
				Object cmdInstance = cmdClass.newInstance();	//ش Ŭ ü Ѵ
				
				mActionMap.put(cmd, cmdInstance);					//׼ Ŭ ʿ 
			}
			catch(Exception e){ e.printStackTrace(); }
		}
	}
	
	/** get  û óѴ */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}

	/** post  û óѴ */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}
	/**
	 * get/post  û  óϴ ޼ҵ
	 * @param request - û ü
	 * @param response -  ü
	 * @throws ServletException
	 * @throws IOException
	 */
	private void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		request.setCharacterEncoding("utf-8");		//û ĳͼ 
		response.setCharacterEncoding("utf-8");		// ĳͼ 
		
		String type = request.getRequestURI().substring(request.getRequestURI().lastIndexOf("/")+1);	//û url  Ŀǵ带 ´
		String nextPage="";	//̵ .    ּ
		
		BkAction action= (BkAction)mActionMap.get(type);		//û Ŀǵ忡  ó ü
		
		if(action !=null)
			nextPage = action.action(request, response);			//û  ó ü  ۾ ó    ּҸ ޾ƿ´
		else
			nextPage = "notaddr.jsp";									//û ü  ⺻  ̵
		
		//û ۾ ó  
		RequestDispatcher rd = request.getRequestDispatcher(nextPage);
		rd.forward(request, response);
	}
}